/*
 * Utils.
 * Typically used in module edit.
 *
 * @package    mod_wfsim
 * @copyright 2015 onwards Catalyst IT Europe Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$(function() {

  // make textareas read-only
  $('#mform1 .fcontainer.hinst textarea').each(function(i) {
    // id_1_hinst_filenames etc.
    $(this).prop('readonly', true);
    $(this).addClass('readonly');
  });

  // Set overlay base when related image base is set.
  // No easy way to attach handler - so check all inputs for id_n_hinst_image_base ones.
  $('#mform1 .fcontainer.hinst input').change(function(i) {
    var iid = $(this).attr('id');
    if (typeof iid != 'undefined') {
      var ida = iid.split('_'); // id_4_hinst_image_base.
      if (ida[2] == 'hinst' && ida[3] == 'image' && ida[4] == 'base') {
        var itarget = '#mform1 input#id_' + ida[1] + '_hinst_overlay_base';
//        if (typeof $(itarget).val() == 'undefined') {
//          console.log('val1' + $(this).val());
//          console.log('val2' + $(itarget).val());
//        }
        // Force set.
        $(itarget).val($(this).val() + '/ov');
      }
    }
  });

  // Set delete hinst dropdown text colour to red if yes selected.
  //$('select.[id$="_hinst_delete"]').change(function(ev)  (not work on jquery)
  $('#mform1 .fcontainer.hinst select').change(function(ev) {
    // <select id="id_1_hinst_delete" name="1_hinst_delete">
    var namea = $(this).attr('name').split('_');
    if (namea[2] != 'delete') {
      return;
    }
    var sel = '#mform1 select[name="' + namea[0] + '_hinst_delete"]';
    if ($(sel + ' option:selected').text() == 'Yes') {
      $(sel).css('color', 'red');
      // Set option colour.
      $(sel + ' option').css('color', 'black');
    } else {
      $(sel).css('color', 'black');
    }

  });

});


// Setup.
getCssRules = function(filter) {
  var s = {}; // Plain Object of property/value pairs.
  var sheets = document.styleSheets;
  var pv = '';
  for (var i in sheets) {
    var shhref = sheets[i].href;
    if (shhref == null || shhref == 'undefined') {
      continue;
    }
    // Our stylesheet embedded with css 'all': // .../clean/1447680140/all.
    if (shhref.indexOf('/all', shhref.length - 4) !== -1) {
      var rules = sheets[i].rules || sheets[i].cssRules;
      for (var r in rules) {
        var rulesr = rules[r]; // CSSStyleRule.
        // https://developer.mozilla.org/en-US/docs/Web/API/CSSStyleRule

        var cssseltxt = rulesr.selectorText; // #indexpage #wrapper
        var cssstyle = rulesr.style; // CSSStyleDeclaration
        if (rulesr instanceof CSSStyleRule) { //  && cssseltxt != 'undefined' && cssseltxt != null
          // Get our selector.
          if (cssseltxt.indexOf(filter) != -1) {
            var cssstyletxt = cssstyle.cssText; //  margin: 0px 20px 20px;
            var csspv = cssstyletxt.split(";");
            for (var j in csspv) {
              if (csspv[j].trim() != '') { // Skip trailing bits.
                pv = csspv[j].split(":");
                if (pv.length != 2) { // Skip trailing bits.
                  continue;
                }
                s[pv[0].toLowerCase().trim()] = (pv[1].trim());
              }
            }
          }
        }
      }
    }
  }
  return s;
}

debugEvent = function(e, showdir) {
  console.log('debugEvent() t parid=' + $(e.target).parent().attr('id') + ' cT parid=' + $(e.currentTarget).parent().attr('id'));

  console.log('e.currentTarget tag=' + e.currentTarget.tagName + ' id=' + e.currentTarget.id + ' class=' + e.currentTarget.className); // div.dropzone
  if (showdir) {
    console.dir(e.currentTarget);
  }

  console.log('e.target tag=' + e.target.tagName + ' id=' + e.target.id + ' class=' + e.target.className);
  if (showdir) {
    console.dir(e.target);
  }
}

findDuplicateIds = function() {
  var ids = {};
  var found = false;

  $('[id]').each(function() {
    if (this.id && ids[this.id]) {
      found = true;
      console.warn('findDuplicateIds: Duplicate ID #' + this.id);
    }
    ids[this.id] = 1;
  });

  if (found) {
    alert('findDuplicateIds: Duplicate IDs found - see console');
  } else {
    console.log('findDuplicateIds: No duplicate IDs found');
  }
}

padNumber =  function(number) {
  if (number < 10) {
    return '0' + number;
  }
  return number.toString();
}
